function doPost(e) {
  try {
    var sheet = SpreadsheetApp.openById(
      "1FKljaW5eEbhj5tJfCfEGi7QbEhq7ZfskoaPNXvyL1wU"
    ).getActiveSheet();
    var data = JSON.parse(e.postData.contents);

    // Insert data into the sheet
    sheet.appendRow([
      new Date(),
      data.email || "",
      "Subscribed", // Status
    ]);

    // Return success response
    return ContentService.createTextOutput(
      JSON.stringify({
        status: "success",
        message: "Successfully subscribed to newsletter!",
      })
    ).setMimeType(ContentService.MimeType.JSON);
  } catch (error) {
    console.error("Error in Newsletter Form doPost:", error);

    // Return error response
    return ContentService.createTextOutput(
      JSON.stringify({
        status: "error",
        message: "Newsletter subscription failed: " + error.toString(),
      })
    ).setMimeType(ContentService.MimeType.JSON);
  }
}

/* 
Google Sheet Headers (Row 1):
Timestamp | Email | Status

Deploy Settings:
- Execute as: Me
- Who has access: Anyone
- Copy the deployment URL and replace YOUR_NEWSLETTER_APPS_SCRIPT_URL in the JavaScript
*/
